<?php
require_once "auth.php"; // <--- ESTO DEBE SER LA LÍNEA 1
require_once '../config/db.php';
require_once 'includes/header.php';
require_once 'includes/sidebar.php';
require_once 'includes/navbar.php';

$asesores = $pdo->query("SELECT * FROM team_members ORDER BY id ASC")->fetchAll(PDO::FETCH_ASSOC);
?>

<main class="flex-1 overflow-y-auto p-6 md:p-8 relative">
    <div class="max-w-6xl mx-auto relative z-10">
        <div class="flex justify-between items-center mb-8">
            <div>
                <h1 class="font-display font-black text-3xl text-gray-900 dark:text-white uppercase">Nuestro Equipo</h1>
                <p class="text-sm text-gray-500">Gestión de personal de JFD Importaciones.</p>
            </div>
            <a href="nuevo_asesor.php" class="bg-brand-red hover:bg-brand-red_hover text-white px-6 py-3 rounded-lg font-bold uppercase tracking-wider shadow-lg transition-all flex items-center gap-2">
                <i class="ri-user-add-line text-xl"></i> Nuevo Asesor
            </a>
        </div>

        <div class="mb-4 relative">
            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                <i class="ri-search-line text-gray-400"></i>
            </div>
            <input type="text" id="buscador-asesores" placeholder="Buscar por nombre, perfil, correo..." 
                   class="w-full md:w-1/3 pl-10 pr-4 py-2 border border-gray-200 dark:border-white/10 rounded-lg bg-white dark:bg-brand-dark text-gray-900 dark:text-white focus:outline-none focus:border-brand-red dark:focus:border-brand-red transition-colors shadow-sm">
        </div>

        <div class="bg-white dark:bg-brand-dark rounded-xl shadow-sm border border-gray-100 dark:border-white/5 overflow-hidden">
            <table class="w-full text-left text-sm" id="tabla-asesores">
                <thead class="bg-gray-50 dark:bg-white/5 text-xs uppercase font-bold text-gray-500 dark:text-gray-300">
                    <tr>
                        <th class="px-6 py-4">N°</th> 
                        <th class="px-6 py-4">Perfil</th>
                        <th class="px-6 py-4">Contacto</th>
                        <th class="px-6 py-4 text-right">Acciones</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100 dark:divide-white/5">
                    <?php 
                    $count = 1; // Inicializamos el contador
                    foreach($asesores as $a): 
                    ?>
                    <tr class="hover:bg-gray-50 dark:hover:bg-white/5 transition-colors fila-asesor">
                        <td class="px-6 py-4 font-mono font-bold text-gray-400">
                            <?php echo str_pad($count++, 2, "0", STR_PAD_LEFT); ?>
                        </td>
                        <td class="px-6 py-4">
                            <div class="flex items-center gap-4">
                                <div class="w-12 h-12 rounded-full bg-gray-200 dark:bg-white/10 overflow-hidden border-2 border-white dark:border-brand-dark shadow-sm">
                                    <?php 
                                        $imgUrl = ($a['photo_url'] && $a['photo_url'] != 'default_avatar.jpg') 
                                            ? "../public/img/asesores/" . $a['photo_url'] 
                                            : "../public/img/default_avatar.jpg";
                                    ?>
                                    <img src="<?php echo $imgUrl; ?>" class="w-full h-full object-cover">
                                </div>
                                <div>
                                    <div class="font-bold text-gray-900 dark:text-white text-base nombre-asesor"><?php echo $a['full_name']; ?></div>
                                    <div class="text-xs font-bold text-brand-red uppercase tracking-wider cargo-asesor"><?php echo $a['position']; ?></div>
                                </div>
                            </div>
                        </td>
                        <td class="px-6 py-4">
                            <div class="flex gap-3 text-lg contacto-asesor">
                                <?php if($a['whatsapp']): ?>
                                    <a href="https://wa.me/<?php echo $a['whatsapp']; ?>" target="_blank" class="text-green-500 hover:scale-110 transition-transform"><i class="ri-whatsapp-fill"></i> <span class="hidden"><?php echo $a['whatsapp']; ?></span></a>
                                <?php endif; ?>
                                <?php if($a['email']): ?>
                                    <a href="mailto:<?php echo $a['email']; ?>" class="text-blue-500 hover:scale-110 transition-transform"><i class="ri-mail-fill"></i> <span class="hidden"><?php echo $a['email']; ?></span></a>
                                <?php endif; ?>
                            </div>
                        </td>
                        <td class="px-6 py-4 text-right space-x-2">
                            <a href="editar_asesor.php?id=<?php echo $a['id']; ?>" class="inline-flex items-center justify-center w-8 h-8 rounded bg-blue-50 text-blue-600 hover:bg-blue-600 hover:text-white transition-all"><i class="ri-pencil-line"></i></a>
                            <form action="eliminar_asesor.php" method="POST" id="form-delete-<?php echo $a['id']; ?>" class="inline-block">
                                <input type="hidden" name="id" value="<?php echo $a['id']; ?>">
                                <button type="button" onclick="confirmDelete(<?php echo $a['id']; ?>, '<?php echo $a['full_name']; ?>')" class="inline-flex items-center justify-center w-8 h-8 rounded bg-red-50 text-red-600 hover:bg-red-600 hover:text-white transition-all"><i class="ri-delete-bin-line"></i></button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</main>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const buscador = document.getElementById('buscador-asesores');
    const filas = document.querySelectorAll('.fila-asesor');

    buscador.addEventListener('keyup', function() {
        const textoBusqueda = this.value.toLowerCase();

        filas.forEach(fila => {
            // Extraemos el texto de toda la fila para que pueda buscar por nombre, cargo o contacto
            const contenidoFila = fila.textContent.toLowerCase();
            
            if (contenidoFila.includes(textoBusqueda)) {
                fila.style.display = ''; // Muestra la fila
            } else {
                fila.style.display = 'none'; // Oculta la fila
            }
        });
    });
});
</script>

<?php require_once 'includes/footer.php'; ?>